// Parameter Copy.js
//
// @author Hiroto Tsubaki (tg_jp) tg@tres-graficos.jp
//
// Tool script ( ~/Library/Application Support/Cheetah3D/scripts/Tool to install )
//


function buildUI( tool ) {
    
    tool.addParameterSeparator("Parameter Copy");
    
    tool.addParameterLink("copy from", false);
    
    tool.addParameterBool("copy position", 0, 0, 1, false, false);
    tool.addParameterBool("copy rotation", 0, 0, 1, false, false);
    tool.addParameterBool("copy scale", 0, 0, 1, false, false);
    tool.addParameterString("copy other params.", "", false)+
    
    tool.addParameterButton("copy", "copy", "copyParameters");

    tool.addParameterSeparator("Helper");
    tool.addParameterButton("from parameters", "check", "checkObjectFrom");
    tool.addParameterButton("target parameters", "check", "checkObjectTarget");
}

function copyParameters( tool ) {
  var copyFrom = tool.getParameter("copy from");
  var copyTarget = tool.document().selectedObject();
  
  if (!copyFrom || !copyTarget) return;
  
  if (copyTarget.recordParametersForUndo) copyTarget.recordParametersForUndo();
  
  if (tool.getParameter("copy position")) {
    copyTarget.setParameter("position", copyFrom.getParameter("position"));
  }
  
  if (tool.getParameter("copy rotation")) {
    copyTarget.setParameter("rotation", copyFrom.getParameter("rotation"));
  }

  if (tool.getParameter("copy scale")) {
    copyTarget.setParameter("scale", copyFrom.getParameter("scale"));
  }
  
  var others = tool.getParameter("copy other params.");
  if (others) {
    var otherParams = others.split(",");
    
    for (var i = 0;i < otherParams.length;i++) {
      var param = otherParams[i];
      
      copyTarget.setParameter(param, copyFrom.getParameter(param));
    }
  }
  
  copyTarget.update();
}

function checkObjectFrom( tool ) {
  var obj = tool.getParameter("copy from");
  
  showObjectInfo( obj, "Parameters: from object" );
}

function checkObjectTarget( tool ) {
  var obj = tool.document().selectedObject();
  
  showObjectInfo(obj, "Parameters: target object" );
}

function showObjectInfo( obj, title ) {
  if (!obj) {
    OS.beep();
    return;
  }
  var info = obj.parameterInfo();
  
  var str = '';
  for(var i = 0;i < info.length;i++) {
    str += info[i][0] + " ["+info[i][1]+"] " + "\n";
  }
  
  OS.messageBox( title, str );
}
